#ifndef __C_BUFFERMANAGER_H
#define __C_BUFFERMANAGER_H

#include "Interfaces/cObject.h"
#include "ostream.h"

#define DEFAULT_BUFFER_CACHE_SIZE 128

class cStack;
class cMsgBuffer;

/*
 * cBufferManager.h
 *
 * Manages message buffers.
 */
class cBufferManager : public cObject
{

  public:
	static cMsgBuffer*	GetBuffer();
	static bool			ReturnBuffer(cMsgBuffer* msgBuffer);
	static void*		Alloc(unsigned int size);
	static void			Free(void* memblock);
	static int			NumFreeBuffers();
	static void			PrintStats(ostream &s);

  private:
	static unsigned int	mNumAlloc;
	static unsigned int	mNumFree;
	static unsigned int	mBufferAlloc;
	static unsigned int	mBufferFree;
	static cStack		mStack;
};

#endif